* negbin_plot.sas;
title "Plot probabilities for the negative binomial distribution";
title2 "m = 5, k = 5";
data negbin_plot;
	* negative binomial parameters here;
	m = 5; k = 5;
	* Maximum value of y for plot;
	ymax = 20;
	do y=0 to ymax;
		* Negative binomial distribution function;
	    proby = (gamma(k+y)/(gamma(y+1)*gamma(k)))*((m/(k+m))**y/(1+m/k)**k);
		* Output y and proby to SAS data file;
		output;
	end;
run;
* Print data;
proc print data=negbin_plot;
run;
* Plot probabilities;
proc gplot data=negbin_plot;
	plot proby*y=1 / vref=0 wvref=3 vaxis=axis1 haxis=axis1;
	symbol1 i=needle v=dot c=red width=3 height=2;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
run;
quit;
